package presentation.graph;

/**
 * @author Alberto Iachini
 */

import java.awt.geom.Point2D;

import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;


public class FinalStateVertexView extends VertexView {
	

	private static final long serialVersionUID = -3550944088851791730L;
	public static transient FinalStateVertexRenderer renderer;
	
	static
	{
		try
		{
			renderer = new FinalStateVertexRenderer();
		}
		catch(Error e)
		{
			// No vertex renderer
		}
	}

	public FinalStateVertexView()
	{
		super();
	}
	
	public FinalStateVertexView(Object cell)
	{
		super(cell);
	}
	
	public CellViewRenderer getRenderer() {
		return renderer;
	}
	
	public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
		if (getRenderer() instanceof FinalStateVertexRenderer)
			return ((FinalStateVertexRenderer) getRenderer()).getPerimeterPoint(this,
					source, p);
		return super.getPerimeterPoint(edge, source, p);
	}
}
